# ValidMind sample notebooks

Our [Jupyter Notebook](https://jupyter.org/) code samples are designed to showcase the capabilities and features of ValidMind, while also providing you with useful examples that you can build on and adapt for your own use cases.

Sample notebooks are organized into the following folders:

* `notebooks/code_samples` — Showcase end-to-end functionality for documenting models
* `notebooks/how_to` — Learn how to use specific ValidMind features, e.g. how to list all test suites
* `notebooks/tutorials` — Get step-by-step instructions and learn about ValidMind concepts in depth
* `notebooks/code_sharing` — Share your own notebooks or document code internally
* `notebooks/archive` — Deprecrated notebooks, that have either been retired or replaced with newer content


## Getting started

ValidMind enables organizations to identify, document, and manage model risks for all types of models, including AI/ML models, LLMs, and statistical models. As a model developer, you use the ValidMind Library to automate documentation and validation tests, and then use the ValidMind Platform to collaborate on documentation projects. Together, these products simplify model risk management, facilitate compliance with regulations and institutional standards, and enhance collaboration between yourself and model validators.

If this is your first time trying out ValidMind, you can make use of the following resources alongside our sample notebooks:

- [Get started](https://docs.validmind.ai/get-started/get-started.html) — The basics, including key concepts, and how our products work
- [Get started with the ValidMind Library](https://docs.validmind.ai/developer/get-started-validmind-library.html) —  The path for developers, more code samples, and our developer reference
